#include	"led.h"
#include    "main.h"
#include	"timer.h"
#include	"radio.h"
#include    "string.h"
#include	"button.h"
#include	"eeprom.h"
#include	"variable.h"
#include	"bc5602test.h"
#include	"BC5602_SetParameter.h"

bit	timer2ms;
bit	SystemSleep;
bit	SendPkgWork;
bit	button_change;
bit	BC5602PwrOnInit;
bit	LEDStatusUpdate;
bit UpdataLEDStatus;
bit BC5161_flearning;
bit	BC5161_FlearnFail;

u8	temp;
u8	RadioMode;
u8	key_status;
u8	time_period;
u8	PacketSerial;
u8	LED_Status;
u8	SendPkgCounter;
u8	BC5161_Address_width;
u8  BC5161_device_ID[3];

//*BC5161 Pairing Address*//
uc8  BC5161_Pairing_Address[_Pairing_ADDR_Len_]={_PAIRB0_,_PAIRB1_,_PAIRB2_,_PAIRB3_,_PAIRB4_};
//*BC5602  message Address*//
u8  BC5602_message_Address[_address_len_]={_PKT_ADDRB0_,_PKT_ADDRB1_,_PKT_ADDRB2_,_PKT_ADDRB3_,_PKT_ADDRB4_};

void IO_Init();
void Clear_RamInit();
void ParameterUpdate();
void Switch_InterfaceConfigure();
/*---------------------------------------------------------------------------*/
/*   */
/*---------------------------------------------------------------------------*/
void GenerateTxMessagePkg(void)
{
	PacketSerial++;
	TxPayloadData[0]=PacketSerial;
	TxPayloadData[1]=0x11;
	TxPayloadData[2]=0x22;
	TxPayloadData[3]=0xBC;
	TxPayloadData[4]=key_status;	
}
/*---------------------------------------------------------------------------*/
/*   */
/*---------------------------------------------------------------------------*/
void main(void)
{    
   if((_pdf == TRUE) && (_to == TRUE)) goto WakeUpBegin;
	SystemClockConfigure();						/*set system clock*/
	DelayXmSec(50*T1MS);						/*delay 50ms */	
	IO_Init();									/*IO initial*/
	Clear_RamInit();							/*clear RAM*/	
	LED_InterfaceConfigure();					/*led interface configure*/
	BTN_InterfaceConfigure();					/*button interface configure*/
	Switch_InterfaceConfigure();				/*switch interface configure*/
	ParameterUpdate();							/*RF address & channel update*/
	timebase0_configure();						/*timebase parameters configure*/								
	BC5602PwrOnInit = TRUE;						/*RF configure flag */					
   _emi = TRUE;									/*interrupt enable*/
      
MainLoop:
	while(SystemSleep == FALSE)
	{
		GCC_CLRWDT();
		if(BC5602PwrOnInit)
		{
   			_emi = FALSE;
   			/*BC5602 interface configure*/
			BC5602InterfaceConfigure();
			/*BC5602 register configure*/				
			BC5602RegisterConfigure();
			/*set work mode ,only choose by switch*/			
			RadioConfigure(RadioMode);						
			BC5602PwrOnInit = FALSE;
   			_emi = TRUE;
		}
						
		if(timer2ms)
		{
			timer2ms = FALSE;
			/*scan button*/
			button_change = BTN_ScanStatus();
			if(button_change)	key_status = BTN_GetStatus();
			if(time_period != 0)	time_period--;			
			LED_Process();
		}
		/* RADIO test to Carrier mode */
		if(RadioMode == RADIO_TEST) goto CarrierMode;
		
		/* radio process */
		RadioProcess();
			
		/* button change to send button status */
		if(RadioMode == RADIO_BC5602)				
		{
			if(key_status && !SendPkgWork)
			{
				SendPkgWork = TRUE;
				button_change = FALSE;
				/*update data */
				GenerateTxMessagePkg();
				/*send data*/
				RadioTxData(_RADIO_DATA_WIDTH_);				
				LED_Status = key_status;
				/*turn on led by Key value*/
				if(LED_Status & 0x01)	
					LED1_ON;
				else							
					LED1_OFF;
				if(LED_Status & 0x02)	
					LED2_ON;
				else							
					LED2_OFF;
				if(LED_Status & 0x04)	
					LED3_ON;
				else							
					LED3_OFF;
				LED_STATUS(ENABLE,AlwaysDark_Mode,LED1|LED2|LED3|LED4,0,15);
			}
			/*Packet send success or fail,clear flag*/
			if(radio_tx_success || radio_tx_fail)
			{
				SendPkgWork = FALSE;
				radio_tx_fail = FALSE;
				radio_tx_success = FALSE;
			}			
		}
		/* BC5161 mode receive only */
		if(RadioMode == RADIO_BC5161)
		{
			if(key_status && !BC5161_flearning)
			{
				button_change = FALSE;
				/*enter BC5161 pairing mode*/
				if(key_status == 0x01)
				{		
					BC5161_flearning = TRUE;			
					RadioConfigure(RadioMode);
					LED_STATUS(ENABLE,Flashing_Mode,LED1,16,250);
				}
			}			
			/*BC5161 pairing timeout*/			
			if(BC5161_FlearnFail && BC5161_flearning)
			{
				BC5161_flearning = FALSE;
				BC5161_FlearnFail = FALSE;
				RadioConfigure(RadioMode);				
			}
		}
		
		/* receive payload process */
		if(rx_payload_valid)
		{
			rx_payload_valid = FALSE;
			/*BC5602 for BC5602 mode,read keyvalue by RxPayload*/
			if(RadioMode == RADIO_BC5602)
			{
				if(RxPayloadData[0] != PacketSerial)
				{
					PacketSerial = RxPayloadData[0];
					LED_Status = RxPayloadData[4];
					UpdataLEDStatus = TRUE;
				}
			}
			/*BC5602 for BC5161 mode,read keyvalue by RxPayload*/
			if(RadioMode == RADIO_BC5161)
			{
				if(BC5161_flearning)
				{
					BC5161_flearning = FALSE;
					WriteEeprom(SaveFlag_EEPAddr,Save_Flag);
					WriteEeprom(RFAddLen_EEPAddr,_BC5161_RADIO_ADDR_WIDTH_);
					for(temp=0;temp<_BC5161_RADIO_ADDR_WIDTH_;temp++)
					BC5602_message_Address[temp] = RxPayloadData[_BC5161_RADIO_ADDR_WIDTH_-temp-1];
					MultiWriteEeprom(RFAddress_EEPAddr,BC5602_message_Address,_BC5161_RADIO_ADDR_WIDTH_);
					if(_DEVICE_ID_) {
					for(temp=0;temp<3;temp++)
					BC5161_device_ID[temp] = RxPayloadData[_BC5161_RADIO_ADDR_WIDTH_+temp]; 
					MultiWriteEeprom(RFDeviceID_EEPAddr,BC5161_device_ID,3); }
					RadioConfigure(RadioMode);
					LED_STATUS(ENABLE,BrightToDark_Mode,LED1 | LED2 | LED3,0,50);
					
				}
				else 
				{
					if(_DEVICE_ID_)	LED_Status = RxPayloadData[3];
					else	LED_Status = RxPayloadData[0];
					LED_STATUS(ENABLE,AlwaysDark_Mode,LED1|LED2|LED3,0,15);
					if((~LED_Status) & 0x80)	
						LED1_ON;
					else							
						LED1_OFF;
					if((~LED_Status) & 0x40)	
						LED2_ON;
					else							
						LED2_OFF;
					if((~LED_Status) & 0x20)	
						LED3_ON;
					else							
						LED3_OFF;
					if((~LED_Status) & 0x10)
					{
						LED1_ON;
						LED2_ON;
						LED3_ON;
					}
				}
			}
			/*turn on LED action*/
			if(UpdataLEDStatus)
			{
				UpdataLEDStatus = FALSE;
				if(LED_Status & 0x01)	
					LED1_ON;
				else							
					LED1_OFF;
				if(LED_Status & 0x02)	
					LED2_ON;
				else							
					LED2_OFF;
				if(LED_Status & 0x04)	
					LED3_ON;
				else							
					LED3_OFF;
				LED_STATUS(ENABLE,AlwaysDark_Mode,LED1|LED2|LED3,0,15);
			}
		}
		goto MainLoopEnd;
CarrierMode:
		if(!SendPkgWork)
		{
			BC5602SetupCE(~_CE_);
			BC5602LightSleepMode();
			SendPkgCounter = 5;
			BC5602CarrierRegsSetup();
			BC5602SetRFChannel(SendPkgCounter);
			BC5602CarrierActive();
			SendPkgWork	= TRUE;
		}
		else
		{
			if(button_change)
			{
				button_change = FALSE;
				key_status = BTN_GetStatus();
				if(key_status)
				{
					switch(key_status)
					{
						case 1:
							if(SendPkgCounter > 5)
							{
								SendPkgCounter -= 5;
								LEDStatusUpdate = TRUE;
							}
							break;
						case 2:
							if(SendPkgCounter < 75)
							{
								SendPkgCounter += 5;
								LEDStatusUpdate = TRUE;
							}
							break;
					}
					if(LEDStatusUpdate)
					{
						LEDStatusUpdate = FALSE;
						BC5602CarrierInactive();
						BC5602SetRFChannel(SendPkgCounter);
						BC5602CarrierActive();
					}
				}
			}
		}
MainLoopEnd:
		_nop();		
	}
	_emi = FALSE;
	GCC_HALT();
WakeUpBegin:    
   GCC_CLRWDT();
   if(BC5602GetPWRONStatus()) 
   BC5602PwrOnInit = TRUE;
   SystemSleep = FALSE;
   _emi = TRUE;   
   goto  MainLoop;
}
/*---------------------------------------------------------------------------*/
/*	 */
/*---------------------------------------------------------------------------*/
void SystemClockConfigure()
{   
   _wdtc = 0x57;						/* enable WDT,time-out period=2^18/fs */
   _lvrc = 0x33;						/* LVR voltage = 2.55V */
#if (SYSTEM_CLOCK == FSYS4MHZ)			/* for 4MHZ */
	_smod = 0xE0;						/* system clock=HIRC/2 */
	_nop();
	_nop();
#endif

#if (SYSTEM_CLOCK == FSYS8MHZ)			/* for 8MHZ */
	_smod = 0xE1;						/* system clock=HIRC */
	_nop();
	_nop();
#endif	
	
#if (SYSTEM_CLOCK == FSYS12MHZ)			/* for 12MHZ */
	_smod = 0xE1;						/* system clock=HIRC */
	_nop();
	_nop();
#endif
	while(!_hto);						/* High system oscillator ready */
}
/*---------------------------------------------------------------------------*/
/*	 */
/*---------------------------------------------------------------------------*/
void Switch_InterfaceConfigure()
{
	u8 SwitchValue;
	_pcpu |=0x03; 
	_pcc  |=0x03;
	
	GCC_DELAY(100000);
		
	SwitchValue = _pc & 0x03;
	
	switch(SwitchValue)
	{
		case 1:
			RadioMode = RADIO_TEST;
		break;
		case 2:
			RadioMode = RADIO_BC5602;
		break;
		case 3:
			RadioMode = RADIO_BC5161;	
		break;
	}	
}
/*---------------------------------------------------------------------------*/
 
/*---------------------------------------------------------------------------*/
void Clear_RamInit()
{
	_bp = 0;
	_mp1 = 0x80;
	for(_tblp = 0x80;_tblp >0;_tblp--)
	{
		_iar1 = 0;
		_mp1++;
	}
	_mp1 = 0x80;
	_bp++;
	for(_tblp = 0x80;_tblp >0;_tblp--)
	{
		_iar1 = 0;
		_mp1++;
	}
	_bp=0;	
}
/*---------------------------------------------------------------------------*/
 
/*---------------------------------------------------------------------------*/
void IO_Init()
{
	_papu |= 0xff;
	_pac  |= 0xff;
	_pbpu |= 0x7f;
	_pbc  |= 0x7f;
	_pcpu |= 0x07;
	_pcc  |= 0x07;
}
/*---------------------------------------------------------------------------*/
 
/*---------------------------------------------------------------------------*/
void ParameterUpdate()
{
	u8 i;
	
	radio_channel_table[0] =  _HOP_Freq1_;
	radio_channel_table[1] =  _HOP_Freq2_;
	radio_channel_table[2] =  _HOP_Freq3_;
	
	if(RadioMode == RADIO_BC5161)
	{
		
		if(ReadEeprom(SaveFlag_EEPAddr) == Save_Flag)
		{
			BC5161_Address_width = ReadEeprom(RFAddLen_EEPAddr);
			for(i=0;i<BC5161_Address_width;i++)
			BC5602_message_Address[i] = ReadEeprom(i+RFAddress_EEPAddr);
			if(_DEVICE_ID_) {
			for(i=0;i<3;i++)
			BC5161_device_ID[i] = ReadEeprom(i+RFDeviceID_EEPAddr); }
		}
	}
	
	if(RadioMode == RADIO_BC5602)
	{
		BC5602_message_Address[0] = _PKT_ADDRB0_;
		BC5602_message_Address[1] = _PKT_ADDRB1_;
		BC5602_message_Address[2] = _PKT_ADDRB2_;
		BC5602_message_Address[3] = _PKT_ADDRB3_;
		BC5602_message_Address[4] = _PKT_ADDRB4_;
	}
}

